function results = multiclassSVM(testcorp,traincorp,groups,~)
%winner takes it all Multiclass svm hack (matlab only supports binary classification). currenty only works for linear classifier
%due to value scaling.
ugroups=unique(groups);
nClass = length(ugroups);
dim1 = size(testcorp,1);
resMatrix=zeros(dim1,nClass); %preallocates a result matrix for N one versus all comparisons

%svmStruct =svmtrain(traincorp,groups);
%results = svmclassify(svmStruct,testcorp);

options = optimset('MaxIter',100000);
for i=1:nClass
    gi_v_all = groups~=i;

    svmstruct = svmtrain(traincorp,gi_v_all,'Method','QP','quadprog_opts',options);
    resMatrix(:,i)=svmClassifyVal(svmstruct,testcorp);
end

[~,i]=max(resMatrix,[],2); %find indices for winner takes it all 

results=ugroups(i);

    function f = svmClassifyVal(svmStruct,testcorp)
        if ~isempty(testcorp)
            % shift and scale the data if necessary:
            %sampleOrig = testcorp;
            if ~isempty(svmStruct.ScaleData)
                for c = 1:size(testcorp, 2)
                    testcorp(:,c) = svmStruct.ScaleData.scaleFactor(c) * ...
                        (testcorp(:,c) +  svmStruct.ScaleData.shift(c));
                end
            end
        end
        f = (feval(svmStruct.KernelFunction,svmStruct.SupportVectors,testcorp,svmStruct.KernelFunctionArgs{:})'*svmStruct.Alpha(:)) + svmStruct.Bias;
        
    end

end
